﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MicroRWD.MFIC
{
    #region EventArgs
// TODO: If this is identical to Event.cs in QT namespace then combine
    // Status update event arguments
    public class StatusUpdateEventArgs : EventArgs
    {
        #region Public Properties

        // The latest status
        public Status Status { get; set; }

        #endregion


        #region Constructor

        // Constructs  anew status update event arguments instance
        public StatusUpdateEventArgs(Status _status)
        {
            Status = _status;
        }

        #endregion
    }

    public class ActiveTabEventArgs : EventArgs
    {
        #region Public Properties

        // The latest status
        public ViewMode viewMode { get; set; }

        #endregion


        #region Constructor

        // Constructs  a new active tab event arguments instance
        public ActiveTabEventArgs(ViewMode _viewMode)
        {
            viewMode = _viewMode;
        }

        #endregion

    }

    #endregion


    #region Delegates

    // Delegate to handle despatch of status update events
    public delegate void StatusUpdateEventHandler(object sender, StatusUpdateEventArgs args);

    // Delegate to handle despatch of active tab events
    public delegate void ActiveTabEventHandler(object sender, ActiveTabEventArgs args);

    #endregion
}
